<?php
/**
 * toggle_status.php — inspections
 * يقلب حالة السجل بين active / inactive ويطبع النص الجديد فقط.
 * يعمل مع PDO ($pdo) أو mysqli ($conn) حسب ما يوفره ملف config.php.
 */

header('Access-Control-Allow-Origin: *');
header('Content-Type: text/plain; charset=utf-8');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// لا نطبع تحذيرات HTML للمستخدم النهائي
ini_set('display_errors', 0);
error_reporting(E_ALL);

// تضمين ملف الاتصال: أولاً من نفس المجلد، ثم من الأعلى كاحتياط
$configLoaded = false;
$here = __DIR__ . '/config.php';
$up   = dirname(__DIR__) . '/config.php';
if (is_file($here)) { require_once $here; $configLoaded = true; }
elseif (is_file($up)) { require_once $up; $configLoaded = true; }

if (!$configLoaded) {
  echo 'error';
  exit;
}

// تحقق من id
if (!isset($_POST['id'])) { echo 'error'; exit; }
$id = intval($_POST['id']);
if ($id <= 0) { echo 'error'; exit; }

try {
  // أولوية لاستخدام PDO إن وُجد
  if (isset($pdo) && $pdo instanceof PDO) {

    // اجلب الحالة الحالية
    $stmt = $pdo->prepare('SELECT status FROM inspections WHERE id = ? LIMIT 1');
    $stmt->execute([$id]);
    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row) { echo 'error'; exit; }

    $current = strtolower((string)$row['status']) === 'active' ? 'active' : 'inactive';
    $next = ($current === 'active') ? 'inactive' : 'active';

    // حدث
    $up = $pdo->prepare('UPDATE inspections SET status = ? WHERE id = ?');
    $ok = $up->execute([$next, $id]);

    echo $ok ? $next : 'error';
    exit;

  } elseif (isset($conn) && $conn instanceof mysqli) {
    // دعم mysqli إذا كان ملف الاتصال يستخدمه

    // اجلب الحالة
    if (!$stmt = $conn->prepare('SELECT status FROM inspections WHERE id = ? LIMIT 1')) {
      echo 'error'; exit;
    }
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res ? $res->fetch_assoc() : null;
    $stmt->close();

    if (!$row) { echo 'error'; exit; }

    $current = (strtolower((string)$row['status']) === 'active') ? 'active' : 'inactive';
    $next = ($current === 'active') ? 'inactive' : 'active';

    // حدث
    if (!$up = $conn->prepare('UPDATE inspections SET status = ? WHERE id = ?')) {
      echo 'error'; exit;
    }
    $up->bind_param('si', $next, $id);
    $ok = $up->execute();
    $up->close();

    echo $ok ? $next : 'error';
    exit;

  } else {
    // لا PDO ولا mysqli متوفرين
    echo 'error';
    exit;
  }

} catch (Throwable $e) {
  // لا تطبع تفاصيل الخطأ للمستخدم
  echo 'error';
  exit;
}
