<?php
// save_inspections.php
header('Content-Type: application/json; charset=utf-8');
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  http_response_code(405);
  echo json_encode(['ok'=>false,'error'=>'USE_POST']); exit;
}

require_once __DIR__ . '/config.php'; // ملف الاتصال فقط

try {
  $pdo = db();               // دالة الاتصال من config.php
  $TABLE = 'inspections';

  $get = fn($k) => isset($_POST[$k]) ? trim((string)$_POST[$k]) : null;

  // مفاتيح المصفوفة = أسماء الأعمدة الجديدة (بدون Bus)
  // قيمها تُقرأ من حقول النموذج الحالية (القديمة) لكي لا تغيّر الواجهة الآن
  $data = [
    'report_type'            => $get('service_type'),

    'ownerName'              => $get('ownerName'),
    'plateNum'               => $get('plateNum'),
    'chassisNum'             => $get('chassisNum'),
    'manufacturer'           => $get('manufacturer'),
    'modelYear'              => $get('modelYear'),
    'model'                  => $get('model'),
    'color'                  => $get('color'),
    'odometer'               => $get('odometer'),
    'serialNum'              => $get('serialNum'),
    'docSerialNum'           => $get('docSerialNum'),

    'inspDateGregorian'      => $get('inspDateGregorian'),
    'inspDateHijri'          => $get('inspDateHijri'),
    'inspectionIssueDate'    => $get('inspectionIssueDate'),
    'inspectionExpiryDate'   => $get('inspectionExpiryDate'),
    'validUntilDocGregorian' => $get('validUntilDocGregorian'),
    'validUntilDocHijri'     => $get('validUntilDocHijri'),

    'inspAuthDoc'            => $get('inspAuthDoc'),
    'inspLoc'                => $get('inspLoc'),
    'newInspLoc'             => $get('newInspLoc'),
    'laneNumDoc'             => $get('laneNumDoc'),
    'inspNumDoc'             => $get('inspNumDoc'),
    'stickerNum'             => $get('stickerNum'),
    'attemptNumDoc'          => $get('attemptNumDoc'),

    'sideSlipTest'           => $get('sideSlipTest'),
    'sideSlipPass'           => $get('sideSlipPass'),

    'frontBrakeEff'          => $get('frontBrakeEff'),
    'frontBrakePass'         => $get('frontBrakePass'),
    'frontBrakeImb'          => $get('frontBrakeImb'),
    'frontBrakeImbPass'      => $get('frontBrakeImbPass'),
    'frontBrakeFric'         => $get('frontBrakeFric'),
    'frontBrakeFricPass'     => $get('frontBrakeFricPass'),

    'rearBrakeEff'           => $get('rearBrakeEff'),
    'rearBrakePass'          => $get('rearBrakePass'),
    'rearBrakeImb'           => $get('rearBrakeImb'),
    'rearBrakeFric'          => $get('rearBrakeFric'),
    'rearBrakeFricPass'      => $get('rearBrakeFricPass'),

    'handBrakeEff'           => $get('handBrakeEff'),
    'handBrakePass'          => $get('handBrakePass'),

    'rightLightInt'          => $get('rightLightInt'),
  'rightLightPass'         => $get('rightLightPass'),
  'rightLightDevVert'      => $get('rightLightDevVert'),
  'rightLightDevVertPass'  => $get('rightLightDevVertPass'),
  'rightLightDevHoriz'     => $get('rightLightDevHoriz'),
  'rightLightDevHorizPass' => $get('rightLightDevHorizPass'),
  'leftLightInt'           => $get('leftLightInt'),
  'leftLightPass'          => $get('leftLightPass'),
  'leftLightDevVert'       => $get('leftLightDevVert'),
  'leftLightDevVertPass'   => $get('leftLightDevVertPass'),
  'leftLightDevHoriz'      => $get('leftLightDevHoriz'),
  'leftLightDevHorizPass'  => $get('leftLightDevHorizPass'),

  'coLevel'       => $get('coLevel'),
  'coPass'        => $get('coPass'),
  'smokeDensity'  => $get('smokeDensity'),
  'smokePass'     => $get('smokePass'),
  'hcLevel'       => $get('hcLevel'),
  'hcPass'        => $get('hcPass'),

  'extInsp'       => $get('extInsp'),
  'brakeTest'     => $get('brakeTest'),
  'underbodyTest' => $get('underbodyTest'),
    // status, created_at يملؤهما MySQL تلقائياً
  ];

  // تحضير وتنفيذ الإدخال
  $cols = array_keys($data);
  $ph   = array_map(fn($c)=>":$c", $cols);
  $sql  = "INSERT INTO `$TABLE` (".implode(',', $cols).") VALUES (".implode(',', $ph).")";
  $stmt = $pdo->prepare($sql);
  $stmt->execute($data);

  echo json_encode(['ok'=>true, 'id'=>$pdo->lastInsertId(), 'message'=>'تم الحفظ']);
} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode(['ok'=>false, 'error'=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
}
