<?php
// /apt/inspection_status/get_inspections_bridge.php
require_once __DIR__ . '/config.php'; // يوفّر $pdo

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');

function out($data, int $code = 200){
  http_response_code($code);
  echo json_encode(
    $data,
    JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_INVALID_UTF8_SUBSTITUTE
  );
  exit;
}

/**
 * غيّر اسم الجدول هنا لاسم جدول الفحص الدوري الفعلي
 * الأعمدة المطلوبة: id, report_type, ownerName, created_at
 */
$TABLE = 'inspections'; // ← عدّل الاسم لو مختلف

// بارامترات اختيارية ?q=&page=&limit=
$q     = isset($_GET['q'])     ? trim((string)$_GET['q']) : '';
$page  = isset($_GET['page'])  ? max(1, (int)$_GET['page']) : 1;
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 500;
if ($limit < 1)    $limit = 1;
if ($limit > 1000) $limit = 1000;
$offset = ($page - 1) * $limit;

// تأمين اسم الجدول
if (!preg_match('~^[A-Za-z0-9_]+$~', $TABLE)) {
  out(['error' => 'BAD_TABLE_NAME'], 400);
}

// تأكيد الأعمدة المطلوبة
try {
  $cols = $pdo->query("DESCRIBE `{$TABLE}`")->fetchAll(PDO::FETCH_COLUMN, 0);
  foreach (['id','report_type','ownerName','created_at'] as $col) {
    if (!in_array($col, $cols, true)) {
      out(['ok'=>false, 'error'=>'MISSING_COLUMN', 'message'=>"Column '{$col}' not found in table '{$TABLE}'"], 500);
    }
  }
} catch (Throwable $e) {
  out(['ok'=>false, 'error' => 'DESCRIBE_FAILED', 'message' => $e->getMessage()], 500);
}

// فلترة اختيارية على ownerName / report_type
$where  = '';
$params = [];
if ($q !== '') {
  $where = "WHERE (report_type LIKE :q OR ownerName LIKE :q)";
  $params[':q'] = '%' . $q . '%';
}

// نعيد: id, report_type, ownerName, name_ar (alias), created_at
$sql = "
  SELECT
    id,
    report_type,
    ownerName,
    ownerName AS name_ar,
    created_at
  FROM `{$TABLE}`
  {$where}
  ORDER BY created_at DESC, id DESC
  LIMIT :limit OFFSET :offset
";

try {
  $st = $pdo->prepare($sql);
  foreach ($params as $k => $v) $st->bindValue($k, $v, PDO::PARAM_STR);
  $st->bindValue(':limit',  $limit,  PDO::PARAM_INT);
  $st->bindValue(':offset', $offset, PDO::PARAM_INT);
  $st->execute();
  $rows = $st->fetchAll(PDO::FETCH_ASSOC);

  // تطبيع خفيف
  foreach ($rows as &$r){
    $r['id']          = isset($r['id']) ? (int)$r['id'] : 0;
    $r['report_type'] = (string)($r['report_type'] ?? '');
    $r['ownerName']   = (string)($r['ownerName']   ?? '');
    $r['name_ar']     = (string)($r['name_ar']     ?? $r['ownerName']);
    $r['created_at']  = (string)($r['created_at']  ?? '');
  }
  unset($r);

  out($rows, 200);
} catch (Throwable $e) {
  out(['ok'=>false, 'error' => 'QUERY_FAILED', 'message' => $e->getMessage()], 500);
}
