<?php
// get_expiry_date.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/config.php';

// تهيئة اتصال: يدعم PDO أو mysqli نفس ملف config.php
function out($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

$sn = isset($_GET['sn']) ? trim($_GET['sn']) : '';
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($sn === '' && $id <= 0) {
  out(['ok'=>false, 'error'=>'missing_params']);
}

try {
  if (isset($pdo) && $pdo instanceof PDO) {
    if ($id > 0) {
      $q = $pdo->prepare("SELECT inspectionExpiryDate AS expiry, status 
                          FROM inspections WHERE id = ? LIMIT 1");
      $q->execute([$id]);
    } else {
      // sn = stickerNum (عمود مولّد) لذا نطابق على stickerNum
      $q = $pdo->prepare("SELECT inspectionExpiryDate AS expiry, status 
                          FROM inspections 
                          WHERE stickerNum = ? LIMIT 1");
      $q->execute([$sn]);
    }
    $row = $q->fetch(PDO::FETCH_ASSOC);
  } elseif (isset($conn) && $conn instanceof mysqli) {
    if ($id > 0) {
      $stmt = $conn->prepare("SELECT inspectionExpiryDate AS expiry, status 
                              FROM inspections WHERE id = ? LIMIT 1");
      $stmt->bind_param('i', $id);
    } else {
      $stmt = $conn->prepare("SELECT inspectionExpiryDate AS expiry, status 
                              FROM inspections WHERE stickerNum = ? LIMIT 1");
      $stmt->bind_param('s', $sn);
    }
    $stmt->execute();
    $res = $stmt->get_result();
    $row = $res ? $res->fetch_assoc() : null;
    $stmt->close();
  } else {
    out(['ok'=>false, 'error'=>'no_db']);
  }

  if (!$row) {
    out(['ok'=>false, 'error'=>'not_found']);
  }

  // لو السجل متوقف نُعامله كغير موجود
  if (strtolower((string)$row['status']) !== 'active') {
    out(['ok'=>false, 'error'=>'inactive']);
  }

  $expiry = $row['expiry'] ?? '';
  // نعيد أيضًا حالة صلاحية تاريخ الانتهاء (اختياري)
  $status = 'valid';
  if ($expiry && strtotime($expiry) < strtotime('today')) $status = 'expired';

  out([
    'ok' => true,
    'status' => $status,
    'expiry_date' => $expiry
  ]);

} catch (Throwable $e) {
  out(['ok'=>false, 'error'=>'exception']);
}
