<?php
// .details/search_result.php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');

ini_set('display_errors', 0);
error_reporting(E_ALL);

require_once __DIR__ . '/../config.php';

function out($arr){ echo json_encode($arr, JSON_UNESCAPED_UNICODE); exit; }

$type = isset($_POST['type']) ? trim($_POST['type']) : '';
$sn   = isset($_POST['sn']) ? trim($_POST['sn']) : '';

if ($sn === '' || $type === '') out(['ok'=>false]);

$plateNum   = isset($_POST['plateNum'])   ? trim($_POST['plateNum'])   : '';
$serialNum  = isset($_POST['serialNum'])  ? trim($_POST['serialNum'])  : '';
$chassisNum = isset($_POST['chassisNum']) ? trim($_POST['chassisNum']) : '';

try {
  if (isset($pdo) && $pdo instanceof PDO) {

    if ($type === 'plate' && $plateNum !== '') {
      $sql = "SELECT id, stickerNum AS sn FROM inspections 
              WHERE status='active' AND REPLACE(plateNum,' ','') = REPLACE(?, ' ','') 
              ORDER BY id DESC LIMIT 1";
      $st = $pdo->prepare($sql); $st->execute([$plateNum]);
    } elseif ($type === 'serial' && $serialNum !== '') {
      $st = $pdo->prepare("SELECT id, stickerNum AS sn FROM inspections 
                           WHERE status='active' AND serialNum = ? 
                           ORDER BY id DESC LIMIT 1");
      $st->execute([$serialNum]);
    } elseif ($type === 'chassis' && $chassisNum !== '') {
      $st = $pdo->prepare("SELECT id, stickerNum AS sn FROM inspections 
                           WHERE status='active' AND chassisNum = ? 
                           ORDER BY id DESC LIMIT 1");
      $st->execute([$chassisNum]);
    } else {
      out(['ok'=>false]); 
    }

    $row = $st->fetch(PDO::FETCH_ASSOC);
    if (!$row) out(['ok'=>false]);

    out(['ok'=>true, 'id'=>(int)$row['id'], 'sn'=>$row['sn']]);

  } elseif (isset($conn) && $conn instanceof mysqli) {

    if ($type === 'plate' && $plateNum !== '') {
      $sql = "SELECT id, stickerNum AS sn FROM inspections 
              WHERE status='active' AND REPLACE(plateNum,' ','') = REPLACE(?, ' ','') 
              ORDER BY id DESC LIMIT 1";
      $st = $conn->prepare($sql); $st->bind_param('s',$plateNum);
    } elseif ($type === 'serial' && $serialNum !== '') {
      $st = $conn->prepare("SELECT id, stickerNum AS sn FROM inspections 
                            WHERE status='active' AND serialNum = ?
                            ORDER BY id DESC LIMIT 1");
      $st->bind_param('s',$serialNum);
    } elseif ($type === 'chassis' && $chassisNum !== '') {
      $st = $conn->prepare("SELECT id, stickerNum AS sn FROM inspections 
                            WHERE status='active' AND chassisNum = ?
                            ORDER BY id DESC LIMIT 1");
      $st->bind_param('s',$chassisNum);
    } else {
      out(['ok'=>false]);
    }

    $st->execute();
    $res = $st->get_result();
    $row = $res ? $res->fetch_assoc() : null;
    $st->close();

    if (!$row) out(['ok'=>false]);
    out(['ok'=>true, 'id'=>(int)$row['id'], 'sn'=>$row['sn']]);

  } else {
    out(['ok'=>false]);
  }

} catch (Throwable $e) {
  out(['ok'=>false]);
}
